/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/


#ifndef B_NTEPP_H_INCLUDED
#define B_NTEPP_H_INCLUDED

// **************************************************************************
// NOTE; ntddk.h will NOT compile under VC++ so get rid of all the stuff
// that we don't need in the C-API.  DEVL is defined in the make file for
// the driver

#if (DEVL == 1)
#   define _DDK_BUILD
#endif

#ifdef  _DDK_BUILD
#   include <ntddk.h>
#   include <devioctl.h>
#   define _T(x)      L ## x
#   include "parallel.h"
#   include "parport.h"
#   include <b_ioctl.h>        /* Get IOCTL interface definitions */
#   include <b_ntepp.h>          /* in CAPI */
#   include <timeout.h>       /* SCR; timeouts added 27.11.97 */
#else
#   include <tchar.h>
#endif





//*****************************************************************************
// 23.2.98; added defines for names.
// Change the following 3 items to get a different version of the driver
// that will CO-EXIST with all previous versions.

// NOTE; Change BEST_EPP_DRIVER# and (!!!) HPBEST_DEVICES_PATH

// Device Names
#define BEST_EPP_DRIVER0        _T("BestNtEpp0_B")
#define BEST_EPP_DRIVER1        _T("BestNtEpp1_B")

// The subkey for all HP Best devices
#define HPBEST_DEVICES_PATH     _T("HPBEST_DEVICES_B")


//*****************************************************************************
// BASE name (lpFileName) for call to CreateFile()

#define CREATE_FILE_NAME_EPP0		_T("\\\\.\\Hp" BEST_EPP_DRIVER0)
#define CREATE_FILE_NAME_EPP1		_T("\\\\.\\Hp" BEST_EPP_DRIVER1)



#ifdef  _DDK_BUILD

// ********************************************************************************
// 13 May '97; SCR.  
// The Driver will attach a 0,1 etc. after each of these base names to identify
// individual devices.

// BASE NT device name ... 
#define NTIO_DEVICE_NAME_EPP_0		_T("\\Device\\" BEST_EPP_DRIVER0)
#define NTIO_DEVICE_NAME_EPP_1		_T("\\Device\\" BEST_EPP_DRIVER1)

// BASE symbolic link string for Win32 
#define DOS_DEVICE_NAME_EPP_0		_T("\\DosDevices\\Hp" BEST_EPP_DRIVER0)
#define DOS_DEVICE_NAME_EPP_1		_T("\\DosDevices\\Hp" BEST_EPP_DRIVER1)

/* port device names of the Parallel Port NT System Low Level Driver*/
#define NT_DEVICE_NAME_PAR_0    _T("\\Device\\ParallelPort0")
#define NT_DEVICE_NAME_PAR_1    _T("\\Device\\ParallelPort1")


/* driver local data structure specific to each device object */
typedef struct _LOCAL_DEVICE_INFO {
    ULONG               DeviceType;            /* Our private Device Type */
    BOOLEAN             PortWasMapped;         /* If TRUE, we have to unmap on unload */
    PVOID               PortBase;              /* base port address */
    ULONG               PortCount;             /* Count of I/O addresses used. */
    ULONG               PortMemoryType;        /* HalTranslateBusAddress MemoryType */
    PDEVICE_OBJECT      PortDeviceObject;      /* pointer to corresponding low level port object */
    PFILE_OBJECT        PortDeviceFileObject;  /* pointer to corresponding low level file object */
    BOOLEAN             PortAllocated;
    int                 Regwidth;
    PDEVICE_OBJECT      DeviceObject;          /* The BestNTio device object. */
    BESTTIMEOUTS        CommTimeouts;          /* SCR; 27.11.97 */

} LOCAL_DEVICE_INFO, *PLOCAL_DEVICE_INFO;

/********************* function prototypes ***********************************/
/* */

NTSTATUS DriverEntry(
          IN PDRIVER_OBJECT DriverObject,
          IN PUNICODE_STRING RegistryPath
          );

NTSTATUS NTioCreateEPPDevice(
          IN ULONG PortNumber,
				  IN PDRIVER_OBJECT DriverObject,
				  OUT PDEVICE_OBJECT *ppDevObj
          );

NTSTATUS NTioDispatch(
          IN PDEVICE_OBJECT pDO,
          IN PIRP pIrp
          );

NTSTATUS NTioOpen(
          IN PDEVICE_OBJECT pDO,
          IN PIRP pIrp
          );

NTSTATUS NTioClose(
          IN PDEVICE_OBJECT pDO,
          IN  PIRP pIrp
          );

NTSTATUS NTioIoctlReadPort(
          IN PLOCAL_DEVICE_INFO pLDI,
          IN PIRP pIrp,
          IN PIO_STACK_LOCATION IrpStack
          );

NTSTATUS NTioIoctlWritePort(
          IN PLOCAL_DEVICE_INFO pLDI,
          IN PIRP pIrp,
          IN PIO_STACK_LOCATION IrpStack
          );

NTSTATUS NTioIoctlGetPhysicalAddress(
          IN PLOCAL_DEVICE_INFO pLDI,
          IN PIRP pIrp,
          IN PIO_STACK_LOCATION IrpStack
          );

VOID NTioUnload(
          IN PDRIVER_OBJECT DriverObject
          );


NTSTATUS NTioWrite(
          PDEVICE_OBJECT pDeviceObject,
          PIRP pIrp
          );

NTSTATUS NTioRead(
		      PDEVICE_OBJECT DeviceObject,
		      PIRP Irp
		      );

#endif  /* _DDK_BUILD */

#endif  /* B_NTEPP_H_INCLUDED */
